<?php
namespace Wb4WpTheme\Helpers;

use Wb4WpTheme\Managers\Customize\Customize_Settings;
/**
 * Font helper
 */
final class Template_Helper {
	public static function array_to_inline_css( $array ) {
		$filtered_array = array_filter(
			$array,
			function ( $value ) {
				return ! is_null( $value );
			}
		);

		$inline_string = '';

		foreach ( $filtered_array as $property => $value ) {
			$inline_string .= "$property: $value;";
		}

		return $inline_string;
	}

	public static function get_color_rules_by_index( $setting_name, $colors_map ) {
		$color_index = ! empty( Customize_Settings::get_setting( $setting_name ) ) ? Customize_Settings::get_setting( $setting_name ) : '0';

		return ! empty( $colors_map[ $color_index ] ) ? $colors_map[ $color_index ] : array();
	}

	public static function css_variables_array_to_css_variables_string( $css_variable_map ) {
		$css_variables = array_map(
			function ( $value ) {
				return "var($value)";
			},
			$css_variable_map
		);

		return self::array_to_inline_css( $css_variables );
	}
}
