<?php

use Wb4WpTheme\Managers\Color_Manager;
use Wb4WpTheme\Managers\Customize\Customize_Settings;
use Wb4WpTheme\Managers\Template_Manager;
use Wb4WpTheme\Helpers\Template_Helper;

// phpcs:ignoreFile xss
?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<title>
		<?php
		$metadata = get_option( 'wb4wp_metadata', null );
		echo ( ! empty( $metadata ) && ! empty( $metadata['siteName'] ) ) ? $metadata['siteName'] : get_bloginfo( 'name' );
		?>
	</title>
	<style>
		/** CSS Values 2 */
		:root {
			<?php 
				$global_css_variables = Template_Manager::get_global_css_variables();
				echo Template_Helper::array_to_inline_css( $global_css_variables );
			?>
		}

		body #page.kv-site .kv-page-content {
			--kv-ee-global-font-size-factor: var(--wb4wp-font-size-factor);
			--kv-ee-heading-font-family: var(--wb4wp-font-heading);
			--kv-ee-heading-font-weight: var(--wb4wp-font-heading-weight);
			--kv-ee-body-font-family: var(--wb4wp-font-body);
			--kv-ee-body-font-weight: var(--wb4wp-font-body-weight);
		}
	</style>

	<link rel='stylesheet' href='https://fonts.googleapis.com/css?display=swap&family=<?php echo str_replace( ' ', '+', Customize_Settings::get_setting( 'wb4wp_fonts_section_body_setting' ) ); ?>|<?php echo str_replace( ' ', '+', Customize_Settings::get_setting( 'wb4wp_fonts_section_heading_setting' ) ); ?>' />

	<?php wp_head(); ?>

	<?php
		$post = get_post();
	?>

	<link href="https://components.mywebsitebuilder.com/fonts/font-awesome.css" rel="stylesheet">
</head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>

<?php echo Template_Manager::get_header(); ?>

	<div id="page" class="site kv-site kv-main">
