<?php // @codingStandardsIgnoreStart

use Wb4WpTheme\Managers\Customize\Customize_Settings;
use Wb4WpTheme\Managers\Template_Manager;
use Wb4WpTheme\Helpers\Template_Helper;

$video_background = Customize_Settings::get_setting( 'wb4wp_footer_section_background_video_setting' );
$template_args = array(
	'footer_css_variables'   => [],
);

if ( ! empty( $args ) ) {
	$template_args = array_merge( $template_args, $args );
}

$pattern_color = 'black';

if( ! empty( $template_args['footer_css_variables'] ) ) {
	$current_footer_background_variable = $template_args['footer_css_variables']['--wb4wp-footer-background'];
	$pattern_color = Template_Manager::get_pattern_color( $current_footer_background_variable );
}
?>

<div class="kv-background <?= isset($video_background) ? 'kv-video' : '' ?>" style="background-color: var(--wb4wp-footer-background, transparent)">
	<?php
		$background_style = array(
			'background-size' => !empty(Customize_Settings::get_setting( 'wb4wp_footer_section_background_effect_setting' )) && Customize_Settings::get_setting( 'wb4wp_footer_section_background_effect_setting' ) === 'contain' ? Customize_Settings::get_setting( 'wb4wp_footer_section_background_effect_setting' ) : null,
			'background-attachment' => !empty(Customize_Settings::get_setting( 'wb4wp_footer_section_background_effect_setting' )) && Customize_Settings::get_setting( 'wb4wp_footer_section_background_effect_setting' ) === 'fixed' ? Customize_Settings::get_setting( 'wb4wp_footer_section_background_effect_setting' ) : null,
			'background-color' => 'var(--wb4wp-footer-background)',
			'background-image' => !empty(Customize_Settings::get_setting( 'wb4wp_footer_section_background_image_setting' )) ? 'url('.Customize_Settings::get_setting( 'wb4wp_footer_section_background_image_setting' ).')' : null,
			'opacity' => (int) (!empty(Customize_Settings::get_setting( 'wb4wp_footer_section_background_opacity_setting' )) ? Customize_Settings::get_setting( 'wb4wp_footer_section_background_opacity_setting' ) : '100') / 100,
		)
	?>
	<div 
		class="kv-background-inner pattern-<?php echo $pattern_color; ?>-<?php echo Customize_Settings::get_setting( 'wb4wp_footer_section_background_pattern_index_setting' ); ?>"
		style="<?php echo Template_Helper::array_to_inline_css($background_style); ?>"
	>	
		<?php if(!empty($video_background)):?>
		<video autoplay="true" loop="loop" muted="muted" playsinline="" preload="auto">
			<source 
				type="video/mp4" 
				data-src="<?= $video_background ?>" 
				src="<?= $video_background ?>"
			>
		</video>
		<?php endif; ?>
	</div>
</div>
