<?php
  // @codingStandardsIgnoreStart 
  use Wb4WpTheme\Managers\Customize\Customize_Settings;
  use Wb4WpTheme\Helpers\Template_Helper;

  $defaultCallToAction = array(
    'href' => '',
    'title' => '',
  );
  $callToAction = Customize_Settings::get_setting( 'wb4wp_header_section_call_to_action' );

  if ( empty( $callToAction ) && !empty(Customize_Settings::get_setting( 'wb4wp_contact_information_section_phone_number_setting' ))) {
    $callToAction = [
      "title" => "Call",
      "href" => "tell:" . Customize_Settings::get_setting( 'wb4wp_contact_information_section_phone_number_setting' ),
      "linkType" => "email",
    ];
  } else {
    $callToAction = (array) json_decode($callToAction);
  }

  $callToAction = array_merge($defaultCallToAction, $callToAction);
?>

<?php if ( Customize_Settings::get_setting( 'wb4wp_header_section_cta_button_setting' ) && !empty( $callToAction ) ) : ?>
  <a 
    href="<?php echo $callToAction['href'] ?>"
    class="wb4wp-navbar-button wb4wp-call-button"
    aria-label="<?php echo $callToAction['title'] ?>"
    <?php echo !empty( $callToAction['shouldOpenInTab'] ) && $callToAction['shouldOpenInTab'] ? 'target="_blank"': ''?>
    <?php 
      if ( !empty( $callToAction['textStyle'] ) || !empty( $callToAction['style'] ) ) {
        $style = [];
        
        if ( !empty( $callToAction['textStyle']->{'font-size'} ) ) {
          $style['font-size'] = (100 * $callToAction['textStyle']->{'font-size'}) . '%';
        }

        if ( !empty( $callToAction['style'] ) ) {
          $style = array_merge( $style, (array) $callToAction['style'] );
        }

        echo 'style="'.Template_Helper::array_to_inline_css( $style ).'"';
      }
    ?>
  >
    <?php if( !empty($callToAction['icon']) ): ?>
      <i class="wb4wp-button-icon fa <?php echo $callToAction['icon']->code ?>"></i>
    <?php endif; ?>
    <span>
      <?php echo $callToAction['title'] ?>
    </span>
  </a>
<?php endif; ?>
